<?php

final class ITSEC_Malware_Scanner {
	public static function scan( $site_id = 0 ) {
		_deprecated_function( __METHOD__, '5.8.0', 'ITSEC_Site_Scanner_API::scan' );

		return new WP_Error( 'malware_scanner_deprecated', __( 'The malware scanner has been deprecated. Please switch to the Site Scanner API.', 'better-wp-security' ) );
	}

	/**
	 * This attempts to determine if this is a temporary Sucuri error or something the user needs to take action on.
	 *
	 * @param WP_Error|array $results
	 *
	 * @return bool
	 */
	public static function is_sucuri_error( $results ) {
		_deprecated_function( __METHOD__, '5.8.0' );

		if ( ! is_wp_error( $results ) ) {
			return false;
		}

		$code = $results->get_error_code();

		if ( 'http_request_failed' === $code && strpos( $results->get_error_message(), 'cURL error 52:' ) !== false ) {
			return true;
		}

		// Networking error probably due to a server issue.
		if ( strpos( $code, 'itsec' ) === false ) {
			return false;
		}

		$plugin_conflict_codes = array(
			'itsec-malware-scanner-wp-remote-get-response-malformed',
			'itsec-malware-scanner-wp-remote-get-response-missing-body',
			'itsec-malware-scanner-wp-remote-get-response-empty-body',
		);

		// Probably a plugin conflict.
		if ( in_array( $code, $plugin_conflict_codes, true ) ) {
			return false;
		}

		return true;
	}
}
